/*
**
** Copyright (c) 2019 Argent Software
**
** All Rights Reserved.
**
** ArgSoft Pacific Intellectual Property Holdings (HK), Limited
** 2017-2018 Metropolis Tower
** The Metropolis, 10 Metropolis Drive
** Hong Kong
**
**
**
** This is PROPRIETARY SOURCE CODE of ArgSoft Pacific Intellectual Property Holdings (HK), Limited.
**
** The contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of ArgSoft Pacific Intellectual Property Holdings (HK), Limited.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement.
**
** Unpublished - rights reserved under the Copyright Laws of the United States
** and other countries.
**
*/




/*******************************************************************************************************

This function is used to get short URL path


INPUT:

IN_sURL                 URL path


RETURNS:

JSON Object


**************************************************************  Copyright (c) 2019 Argent Software  ***/
//QQQ
                function 
J100_GetURLPath
               (IN_sURL)
{
var				bMatchFound;	

var             objRegExSplit;

var             objRegExResult;

var				objResult;



bMatchFound		= false;

objRegExSplit   = /:\/{1,3}(.*?)\/([^\/]*?)\/?($|\?.*)/;

objRegExResult  = objRegExSplit.exec(IN_sURL);

if  (!objRegExResult)
    {
    objResult 	= { name: IN_sURL, path: IN_sURL };
	
	bMatchFound	= true;
    }

if  (!objRegExResult[2] &&
	 bMatchFound == false)
    {
    objResult 	= { path: objRegExResult[1], name: objRegExResult[1] };
	
	bMatchFound	= true;
    }
	
if 	(bMatchFound == false)
	{
	objResult	= { path: objRegExResult[1], name: objRegExResult[2] + objRegExResult[3] };
	}



return objResult;
}




/*******************************************************************************************************

This function is used to format time to millseconds/seconds/minutes


INPUT:

IN_iTime                 Time in seconds


RETURNS:

String                  Time string


**************************************************************  Copyright (c) 2019 Argent Software  ***/
//QQQ
                function 
J110_FormatTime
               (IN_iTime,
                IN_sType)
{
var             sReturn;


var             bSkip;

var             iTime;



bSkip           = false;

iTime           = Math.round(IN_iTime * 10) / 10;

iTime           = iTime.toFixed(1);


if  (iTime  < 1000) 
    {
    sReturn = iTime + (IN_sType == "short" ? "ms" : " milliseconds");

    bSkip   = true;
    }

if (iTime   < 60000 &&
    bSkip   == false)
    {
    sReturn = (Math.ceil(iTime / 10) / 100) + (IN_sType == "short" ? "s" : " Seconds");

    bSkip   = true;
    }

if  (bSkip  == false)
    {
    sReturn = (Math.ceil((iTime / 60000) * 100) / 100) + (IN_sType == "short" ? "m" : " Minutes");
    }


return sReturn;
}



/*******************************************************************************************************

This function is used to load Har JSON file and process data as HTML


RETURNS:

Void

**************************************************************  Copyright (c) 2019 Argent Software  ***/
//QQQ

                function
J120_LoadHarJsonFile
               ()
{
var 			iBlockingTime;
			
var				iCount;

var 			iConnectingTime;
			
var 			iDomContentTimeTaken;
			
var 			iEndDateTime;

var 			iEntryItem;

var 			iEntryStartedDateTime;
			
var 			iFirstDateTime;
			
var 			iOffsetLeft;
			
var 			iReceivingTime;
			
var 			iResolvingTime;
			
var 			iSendingTime;
			
var 			iSize;
			
var 			iTimeDiff;
			
var 			iTimelineOffset;

var 			iTimeStamp;

var 			iTimeTaken;
			
var 			iTotalSize;
			
var 			iTotalTimeTaken;
			
var 			iWaitingTime;
			
			
var 			objDate;
			
var 			objEndDate;
			
var 			objEntry;
			
var 			objJSONData;
			
var 			objLastEntry;

var 			objLocalTime;
			
var 			objStartDate;
			
var 			objURLData;
			
var 			objWaterFall;
			
			
			
var 			sAllPageData;
			
var 			sColor;
			
var 			sCurrentbarDate;

var				sDateTime;
			
var 			sData;
			
var 			sFullURL;
			
var 			sHTML;
			
var 			sOldbarDate;
			
var 			sTimeDiffData;
			
var 			sTimeElapsed;
			
var 			sURL;



objLocalTime	= new Date();

iTimeStamp		= objLocalTime.getTime();

sDateTime		= J140_ArgentDateFormat(iTimeStamp, "datetime");


objJSONData 	= JSON.parse(data);

sAllPageData 	= '';

for (iCount 				= 0 ; iCount < objJSONData.length; iCount++)
    {		
    objEntry 				= objJSONData[iCount];
		
    objStartDate 			= new Date(objEntry.sLoadStartTime);
		
    iFirstDateTime 			= objStartDate.getTime();
		
    objLastEntry 			= objEntry.arrWaterfallData[objEntry.arrWaterfallData.length - 1];
		
    objEndDate 				= new Date(objLastEntry.sStartDateTime);
		
		
    iEndDateTime 			= objEndDate.getTime();
		
    iEndDateTime 			= iEndDateTime + objLastEntry.iTotal_MS;
		
    iTotalTimeTaken 		= iEndDateTime - iFirstDateTime;
		
    phaseElapsed 			= iTotalTimeTaken + 1000;

    iDomContentTimeTaken 	= J110_FormatTime(objEntry.iContentLoad_MS, "full");

			
    sData 					= '';
			
    sColor 					= '';
	
    sCurrentbarDate 		= 0;
		
    sHTML 					= '';
			
    sOldbarDate 			= 0;
		
    iTotalSize 				= 0;
	

    for (iEntryItem 		= 0 ; iEntryItem < objEntry.arrWaterfallData.length ; iEntryItem++) 
		{
        objWaterFall 		= objEntry.arrWaterfallData[iEntryItem];
	
        objDate 			= new Date(objWaterFall.sStartDateTime);
	
	
        iEntryStartedDateTime = objDate.getTime();
	
        iTimeDiff 			= iEntryStartedDateTime - iFirstDateTime;
	
        iTimelineOffset 	= ((iTimeDiff / phaseElapsed) * 100).toFixed(2);	
	
        iBlockingTime 		= ((objWaterFall.iStalled_MS < 0) ? 0 : objWaterFall.iStalled_MS);
		
        iResolvingTime 		= iBlockingTime + ((objWaterFall.iDNS_Lookup_MS < 0) ? 0 : objWaterFall.iDNS_Lookup_MS);
		
        iConnectingTime 	= iResolvingTime + ((objWaterFall.iInitial_Connection_MS < 0) ? 0 : objWaterFall.iInitial_Connection_MS);
		
        iSendingTime 		= iConnectingTime + ((objWaterFall.iRequest_Sent_MS < 0) ? 0 : objWaterFall.iRequest_Sent_MS);
		
        iWaitingTime 		= iSendingTime + ((objWaterFall.iRequest_Wait_MS < 0) ? 0 : objWaterFall.iRequest_Wait_MS);
		
        iReceivingTime 		= iWaitingTime + ((objWaterFall.iContent_Download_MS < 0) ? 0 : objWaterFall.iContent_Download_MS);
		


        barBlockingWidth 	= ((iBlockingTime 	/ phaseElapsed) * 100).toFixed(3);
		
        barResolvingWidth 	= ((iResolvingTime 	/ phaseElapsed) * 100).toFixed(3);
		
        barConnectingWidth 	= ((iConnectingTime / phaseElapsed) * 100).toFixed(3);
		
        barSendingWidth 	= ((iSendingTime 	/ phaseElapsed) * 100).toFixed(3);
		
        barWaitingWidth 	= ((iWaitingTime 	/ phaseElapsed) * 100).toFixed(3);
		
        barReceivingWidth 	= ((iReceivingTime 	/ phaseElapsed) * 100).toFixed(3);


        iTimeTaken 			= parseFloat(objWaterFall.iTotal_MS).toFixed(2); 
	
        sTimeElapsed 		= J110_FormatTime(objWaterFall.iTotal_MS, "short");
	
        sFullURL 			= objWaterFall.sURL;	

        objURLData 			= J100_GetURLPath(objWaterFall.sURL);

        sURL 				= objURLData.name;

        iSize 				= Math.round(objWaterFall.iSize_KB * 10) / 10;

        iTotalSize 			= iTotalSize + iSize;

        sCurrentbarDate 	= (iEntryStartedDateTime - iFirstDateTime);

        sColor = '';

        if 	(objWaterFall.sStatus != "OK") 
			{
            sColor = " httperror ";
			}


        iOffsetLeft = (J130_AddCommas(iTimeDiff).toString().length * 5) + 10;

        sData += 	'<tr class="datarow  rowpadding ">' +
					'<td class=" netCol2 ' + sColor + '"><div class="datastatus netLabel ">' 		+ J130_AddCommas(iEntryItem + 1) + '</div></td>' +
					'<td class="linkcol netCol2 ' + sColor + '">' +
					'<div style="margin-left: 0px" class="shortlink netLabel ">' +
						sURL                 + 
					'</div><div style="margin-left: 0px" class="longlink shortlink netLabel ">' 	+ sFullURL + '</div></td>' +
						'<td class=" netCol2 ' + sColor + '"><div class="datastatus netLabel ">' 	+ objWaterFall.sMethod + '</div></td>' +
						'<td class=" netCol2 ' + sColor + '"><div class="datastatus netLabel ">' 	+ objWaterFall.sStatus + '</div></td>' +
						'<td class=" netCol2 ' + sColor + '"><div class="datatype netLabel ">' 		+
						objWaterFall.sType
						+ '</div></td>' +
						'<td class=" netCol2 ' + sColor + '"><div ' +
						'class="datasize netLabel ">' +
						J130_AddCommas(iSize)
						+ '</div></td>' +                    
						'<td class=" netCol2 	"><div class="datawaterfall ">&nbsp;' +
						'<div class="datablocking 	legend " style="left: ' + iTimelineOffset 		+ '%; width:  ' + barBlockingWidth + '%;"></div>' +
						'<div class="dataresolving 	legend " style="left: ' + iTimelineOffset 		+ '%; width:  ' + barResolvingWidth + '%;"></div>' +
						'<div class="dataconnecting 	legend " style="left: ' + iTimelineOffset 	+ '%; width:  ' + barConnectingWidth + '%;"></div>' +
						'<div class="datasending 		legend " style="left: ' + iTimelineOffset 	+ '%; width:  ' + barSendingWidth + '%;"></div>' +
						'<div class="datawaiting 		legend " style="left: ' + iTimelineOffset 	+ '%; width:  ' + barWaitingWidth + '%;"></div>' +
						'<div class="datareceiving 	legend " style="left: ' + iTimelineOffset 		+ '%; width:  ' + barReceivingWidth + '%;">' +
						'<span class="waterfalltime ">' + sTimeElapsed + '</span>' +
					'</div>' +     
					'</td>'  +
					'</tr>';



        sOldbarDate = sCurrentbarDate;

    }


    iTotalTimeTaken = J110_FormatTime(objEntry.iLoad_MS, "full");

    sTimeDiffData = '';
	
	
    if 	(iCount > 0) 
		{
        sHTML += "<br><br><br>"
		}

	

    sHTML += '<div class="pageurltitle"><table class="pageurltitle">'	+ 
				'<tr><td>Session:</td><td>' 			+ objEntry.sTESTName 	+ '</td></tr>' + 
				'<tr><td>URL:</td><td>' 			+ objEntry.sPageURL 	+ '</td></tr>' + 
				'<tr><td>Engine:</td><td>' 			+ objEntry.sEngineName 	+ '</td></tr>' + 	
				'<tr><td>VUser:</td><td>#' 			+ objEntry.iVUser 		+ '</td></tr>' + 			
				'<tr><td>Date/Time:</td><td>' 		+ sDateTime 			+ '</td></tr>' + 
				'</table></div><br>' +
                '<table cellpadding="0" cellspacing="0" style="border-collapse: separate; " class="datatable "><tbody class="harData">';

    sHTML += '<tr class="netSizerRow "><th width="2%"  class="netColMethod tableheader ">&nbsp;</th><th width="60%" style="padding-left:1px" class=" tableheader ">Name</th>' +
                '<th width="5%"  class="netColMethod tableheader ">Method</th><th width="5%" class=" tableheader ">Status</th><th width="15%" class=" tableheader ">Type</th>' +
                '</th><th style="text-align: right;" width="7%" class=" tableheader tableheadersize">Size (KB)</th><th width="100%" class=" tableheader tableheaderwaterfall">Waterfall</th>' +
                '</tr>';


    sTimeDiffData = '<tr class="totalrow  rowpadding ">' +
                        '<td colspan="2" style="padding-left: 3px;" class=" totalcolumn ">' + J130_AddCommas(iEntryItem) + ' Requests</td>' +
                        '<td class=" totalcolumn"><div class="datastatus netLabel "></div></td>' +
                        '<td class=" totalcolumn"><div class="datastatus netLabel "></div></td>' +
                        '<td class=" totalcolumn"><div class="datatype netLabel "></div></td>' +
                        '<td style="text-align: right; padding-right: 1px;" class=" totalcolumn">' + J130_AddCommas(iTotalSize.toFixed(1)) + '</td>' +
                        '<td style="text-align: right; padding-right: 10px;" class=" netCol2 totalcolumn">' + iTotalTimeTaken + " (onload: " + iDomContentTimeTaken + ") " +
                        '</td>' +
                    '</tr>';
					
					

    sHTML +=  sData + sTimeDiffData;
	
	

    sHTML += '</tbody></table>';

    sAllPageData += sHTML;
    }

$('#divHarViewer').html(sAllPageData);

}




/*******************************************************************************************************

This function is used to add comma into a given numeric value


INPUT:

IN_iNumber                  Numeric value


RETURNS:

A String value containing the formatted output


**************************************************************  Copyright (c) 2019 Argent Software  ***/
//QQQ
				function 
J130_AddCommas
				(IN_iNumber) 
{
var szReturn;

var szNumVal;

var szRegexp;


szRegexp = /(\d)(?=(\d{3})+(?!\d))/g;          //  Regular expression string for number formatting

szNumVal = IN_iNumber.toString();

if 	(szNumVal.length <= 3) 
	{
	szReturn = szNumVal;
	}
else 
	{
	szReturn = szNumVal.replace(szRegexp, "$1,")   //  Comma formatted numeric value
	}


return szReturn;
}




/*******************************************************************************************************

This function is used to add comma into a given numeric value


INPUT:

IN_iNumber                  Numeric value


RETURNS:

A String value containing the formatted output


**************************************************************  Copyright (c) 2019 Argent Software  ***/
//QQQ
				function 
J140_ArgentDateFormat
				(IN_iTimeStamp,
				 IN_szType) 
{
var 			szMonth;		

var 			iDay;		

var 			iWeekday;	

var 			iYear;		

var 			iHour;		

var 			iMinute;		

var 			iSecond;	

var 			szDateTime;

var 			Array_szMonth;

var				szTimeZoneRegion;



Array_szMonth		= ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
					  
IN_iTimeStamp		= new Date(IN_iTimeStamp);
					  
szMonth				= IN_iTimeStamp.getMonth();
					  
iDay				= IN_iTimeStamp.getDate();
					  
iWeekday			= IN_iTimeStamp.getDay();
					  
iYear				= IN_iTimeStamp.getFullYear();
					  
iHour				= IN_iTimeStamp.getHours();
					  
iMinute				= IN_iTimeStamp.getMinutes();

iSecond				= IN_iTimeStamp.getSeconds();
					  
szDateTime			= '';
					  
szMonth				= Array_szMonth[szMonth];
					  
if	(iMinute		< 10)
	{
	iMinute		=	"0" + iMinute;
	}

if	(iHour			< 10)
	{                 
	iHour			= "0" + iHour;
	}                 

if	(iSecond		< 10)
	{                 
	iSecond			= "0" + iSecond;
	}           					  
					  
if	(IN_szType		= "datetime")						
	{                 
	szDateTime		= iDay + " " + szMonth + " " + iYear + ' ' + iHour + ":" + iMinute + ":" + iSecond;
	}                 
else                  
	{                 
	szDateTime		= iDay + " " + szMonth + " " + iYear;
	}



return	szDateTime;
}
